**********************************************************************************************
* Do-file used to impute owner-occupied housing assets based on wealth wealth surveys        *
**********************************************************************************************

* Imputation based on age groups.groups of financial income.groups of labor income

* I) Organize the data
***************************

	* Load the data
		use "$wfpat/wfEP04.dta",clear
		append using "$wfpat/wfEP10.dta"
		append using "$wfpat/wfEP98.dta"
		append using "$wfpat/wfEP92.dta"
		* Impossible to use wealth surveys 1986 because value of owner-occupied housing assets as well as associated debts are not reported
		
	* Variables used for imputations

		* Labor income (self-employed income + wages + replacement income)
			gen lr_irpp_foy = rev_act_pens 
	
		* Age groups
			* 20-24, 25-30 , 31-39, 40-49, 50-54, 55-60, 61-65, 66-70, 71-80 and > 80 years old
			capture drop q_age_pr
			gen q_age_pr = 1
			replace q_age_pr = 2 if age >24
			replace q_age_pr = 3 if age >30
			replace q_age_pr = 4 if age >39
			replace q_age_pr = 5 if age >49
			replace q_age_pr = 6 if age >54
			replace q_age_pr = 7 if age >60
			replace q_age_pr = 8 if age >65
			replace q_age_pr = 9 if age >70
			replace q_age_pr = 10 if age >80
			*tab q_age_pr
	
		* Age.groups of financial income
			* Each age groups is split into 4 groups of financial income P0-50, P50-90, P90-99, P99-100
			sort year q_age_pr rfin_irpp_foy lr_irpp_foy id_men
			gen u=uniform()
			replace rfin_irpp_foy=u if rfin_irpp_foy==0
				
			gen pondvr=round(100*pondn) 
			bys year q_age_pr : cumul rfin_irpp_foy [w=pondvr], gen (p100)
			gen p10=p100*100
			gen q_age_fin   = 0
			replace q_age_fin= 50   if p10 >=50 & p10 <90 & q_age_fin==0
			replace q_age_fin= 90   if p10 >=90 & p10 <99 & q_age_fin==0
			replace q_age_fin= 99   if p10 >=99 & q_age_fin==0
			drop p10 p100 pondvr u
			* Adjusment for < 30 years old (only 10% of housing ownership) => No distinction by financial income (they have almost nothing)
				replace q_age_fin=0 if q_age_pr==1 | q_age_pr==2
			

		* Age.groups of financial income.groups of labor income.
			* Each age groups*groups of financial income is split into 5 groupes of labor income P0-25, P25-50, P50-75, P75-90 et P90-100
			sort year q_age_pr q_age_fin lr_irpp_foy id_men
			gen u=13*uniform()
			replace lr_irpp_foy=u if lr_irpp_foy==0
			drop u
		
			gen pondvr=round(100*pondn) 
			bys year q_age_pr q_age_fin : cumul lr_irpp_foy [w=pondvr], gen (p100)
			gen p10=p100*100
			gen q_age_fin_lr  = 0
			replace q_age_fin_lr=25  if p10 >=25 & p10 <50 & q_age_fin_lr==0
			replace q_age_fin_lr= 50   if p10 >=50 & p10 <75 & q_age_fin_lr==0
			replace q_age_fin_lr= 75   if p10 >=75 & p10 <90 & q_age_fin_lr==0
			replace q_age_fin_lr= 90   if p10 >=90 & q_age_fin_lr==0
			drop p10 p100 pondvr
			* Adjusment for the top 1% of financial income (not enough observation to split into labor income)
				replace q_age_fin_lr=0 if q_age_fin==99
				
* II) Statistics for the imputation
*************************************			
		
	* Proportion of owner-occupied housing
		gen prop_immo =0 
		replace prop_immo =pondn if patfon_owner>0
	
	* Weighted amounts
		replace patfon_owner=patfon_owner*pondn
		replace passif_owner=passif_owner*pondn
	
	bys year q_age_pr q_age_fin q_age_fin_lr : egen tot=sum(pondn)
	gen a =1
	bys year q_age_pr q_age_fin q_age_fin_lr : egen obs=sum(a)
	drop a
	collapse (sum)  patfon_owner passif_owner prop_immo (mean) obs tot,by(year q_age_pr q_age_fin q_age_fin_lr)
	
	* Proportion of owner-occupied housing by groups
		replace prop_immo=prop_immo/tot
	
	* Share of total owner-occupied housing assets accruing to each group
		bys year :egen patfon_owner_tot=sum(patfon_owner) 
		gen share_patimmo=100*patfon_owner/patfon_owner_tot
		gen ratio_pass_owner=passif_owner/patfon_owner
		replace ratio_pass_owner=0 if ratio_pass_owner==.
	
	/* To see average debts and owner-occupied housing assets of owners by groups 	
		foreach var of varlist passif_owner patfon_owner {
			replace `var'=`var'/tot/prop_immo if prop_immo~=0
		}
		gen patfon_owner_net=patfon_owner- passif_owner
		drop tot patfon_owner_net */
		
	keep year q* share* prop* ratio*
	
	tempfile base
	save "`base'",replace


* III) Harmonization and correction
*************************************
	
	* Interpolation for missing years		
		
		* Add missing years
		keep if year==1998
		foreach var of varlist year prop_immo share_patimmo ratio_pass_owner {
			replace `var'=.
		}
		tempfile temp
		save "`temp'",replace
		use "`base'",clear
		foreach num of numlist 1993/1997 1999/2003 2005/2009 {
			append using "`temp'"
			replace year=`num' if year==.
		}
		sort year
	
		* Years 1992, 1998, 2004 and 2010
		erase "`temp'"
		erase "`base'"
		tempfile newbase
		save "`newbase'",replace
		tempfile temp
		save "`temp'",replace
		foreach num of numlist 1992 1998 2004 2010 {
			use "`temp'",clear
			keep if year==`num'
			foreach var of varlist  prop_immo share_patimmo  ratio_pass_owner{
				rename `var' `var'`num'
			}
			drop year
			merge m:m q_age_pr q_age_fin q_age_fin_lr using "`newbase'"
			drop _merge
			erase "`newbase'"
			tempfile newbase
			save "`newbase'",replace
		}
		erase "`temp'"
		sort year q_age_pr q_age_fin q_age_fin_lr

	* Interpolation
	
		* Period 1993-1997
			local i =1992
			local j=1998
			foreach var of varlist  prop_immo share_patimmo ratio_pass_owner {
				replace `var'=`var'`i'+(`var'`j' -`var'`i')*(year-`i')/(`j'- `i') if year>`i' & year< `j'
			}
			
		* Period 1998-2004	
			local i =1998
			local j=2004
			foreach var of varlist  prop_immo share_patimmo ratio_pass_owner {
				replace `var'=`var'`i'+(`var'`j' -`var'`i')*(year-`i')/(`j'- `i') if year>`i' & year< `j'
			}
			
		* Period 2004-2010	
			local i =2004
			local j=2010
			foreach var of varlist  prop_immo share_patimmo ratio_pass_owner {
				replace `var'=`var'`i'+(`var'`j' -`var'`i')*(year-`i')/(`j'- `i') if year>`i' & year< `j'
			}
			
		drop *2010 *2004 *1998 *1992
		order year q_age_pr q_age_fin q_age_fin_lr
		sort year q_age_pr q_age_fin q_age_fin_lr

save "$param/Imputation/clef_immo_EP.dta",replace
			


